'---------------------------------------------------------------------
'NAME:      MD2QB2E1.BAS
'DESC:      MD-2 LEVEL 2 QUICK-BASIC MOTION CONTROL EXAMPLE PROGRAM.
'           SHOWS USAGE OF MD2QB2S.BAS SUBROUTINE LIBRARY.
'           START QUICK BASIC WITH /L PARAMETER FOR INTERRUPT SUB.
'BY:        COPYRIGHT (C) 1994 ARRICK ROBOTICS, ROGER ARRICK.
'DATE:      6/7/94
'EDIT:      30
'---------------------------------------------------------------------

'THIS INCLUDE FILE CONTAINS PROCEDURE DECLARATIONS AND GLOBAL VARIABLES.
'$INCLUDE: 'MD2QB2S.BI'

    DIM ENTRY AS STRING
    SCREEN 0
    CLS

    'INITIALIZE MD-2 SYSTEM
    MD2CALFILE = "MD2QB2S.CAL"
    MD2SETUP
   
    IF MD2STATUS = "C" THEN INPUT "Calibration needed, Press ENTER ", HUH$

MENULOOP:
           
    CLS
    PRINT "MD2QB2E1 EXAMPLE PROGRAM                 MD2STATUS: "; MD2STATUS
    PRINT
    PRINT "O  - Turn on an MD-2"
    PRINT "F  - Turn off an MD-2"
    PRINT "P  - Edit, load, save parameters"
    PRINT "L  - Load a sequence"
    PRINT "R  - Run a sequence"
    PRINT "M  - Move motor(s)"
    PRINT "G  - Grid move"
    PRINT "H  - Home a motor"
    PRINT "C  - Circle/arc moves"
    PRINT "CA - Calibrate"
    PRINT "Q  = Quit"
    PRINT
    INPUT "Enter selection ", ENTRY
    ENTRY = UCASE$(ENTRY)

    'Home a motor.
    IF ENTRY = "H" THEN
        INPUT "ENTER MOTOR # TO HOME (1-6) ", MD2MOTOR
        MD2HOME
        GOTO MENULOOP
    END IF
  
    'Quit.
    IF ENTRY = "Q" THEN END
  
    'Run a sequence.
    IF ENTRY = "R" THEN
        MD2POINTER = 1
        DO
            MD2SEQRUN
            IF MD2STATUS <> "O" THEN
                PRINT "STATUS CODE: "; MD2STATUS; "         COMMAND: "; MD2COMMAND
                INPUT "A=ABORT, C=CONTINUE   ", ENTRY
                IF UCASE$(ENTRY) = "A" THEN EXIT DO
            ELSE
                EXIT DO
            END IF
        LOOP
        GOTO MENULOOP
    END IF
  
    'Load a sequence.
    IF ENTRY = "L" THEN
        INPUT "ENTER SEQUENCE FILE NAME TO LOAD ", MD2SEQFILE
        MD2SEQLOAD
        GOTO MENULOOP
        MD2PAREDIT
    END IF

    'Edit parameters.
    IF ENTRY = "P" THEN
        MD2PAREDIT
        GOTO MENULOOP
    END IF
   
    'Move a motor.
    IF ENTRY = "M" THEN
        INPUT "ENTER MOTOR # (1-6,12,34,56) ", MD2MOTOR
        IF MD2MOTOR > 6 THEN
            IF MD2MOTOR = 12 THEN MD2MOTOR1 = 1: MD2MOTOR2 = 2
            IF MD2MOTOR = 34 THEN MD2MOTOR1 = 3: MD2MOTOR2 = 4
            IF MD2MOTOR = 56 THEN MD2MOTOR1 = 5: MD2MOTOR2 = 6
            PRINT "ENTER TARGET FOR MOTOR"; MD2MOTOR1; " "; : INPUT "", MD2TARGET(MD2MOTOR1)
            PRINT "ENTER TARGET FOR MOTOR"; MD2MOTOR2; " "; : INPUT "", MD2TARGET(MD2MOTOR2)
        ELSE
            PRINT "ENTER TARGET FOR MOTOR"; MD2MOTOR; " "; : INPUT "", MD2TARGET(MD2MOTOR)
        END IF
        INPUT "MOVE TYPE (A=ABSOLUTE, R=RELATIVE) ", MD2MOVETYPE
        MD2MOVE
    END IF
   
    'Turn on an MD-2.
    IF ENTRY = "O" THEN
        INPUT "ENTER MOTOR # TO TURN ON MD-2 SYSTEM (12,34,56) ", MD2MOTOR
        MD2ON
    END IF
  
    'Turn off an MD-2.
    IF ENTRY = "F" THEN
        INPUT "ENTER MOTOR # TO TURN OFF MD-2 SYSTEM (12,34,56) ", MD2MOTOR
        MD2OFF
    END IF
   
    'Circle/arc move.
    IF ENTRY = "C" THEN
        INPUT "ENTER MOTOR # PAIR (12,34,56) ", MD2MOTOR
        INPUT "ENTER MOVETYPE (A OR R) ", MD2MOVETYPE
        MD2CIRCLE
    END IF
    
    'Grid move.
    IF ENTRY = "G" THEN
        INPUT "ENTER MOTOR # PAIR (12,34,56) ", MD2MOTOR
        INPUT "ENTER X TARGET ", MD2GRIDTARGETX
        INPUT "ENTER Y TARGET ", MD2GRIDTARGETY
        MD2GRID
    END IF

    'Calibrate.
    IF ENTRY = "CA" THEN
        LOCATE 23, 20: PRINT "CALIBRATING";
        MD2CALIBRATE
        BEEP
        IF MD2STATUS = "O" THEN
            PRINT "CALIBRATION COMPLETE"
        ELSE
            PRINT "ERROR DOING CALIBRATION"
        END IF
        INPUT "PRESS ENTER ", ENTRY
        GOTO MENULOOP
    END IF

    GOTO MENULOOP

