/***** MD2QC2E1.C Level 2 example program for the C language *****/

#include "md2qc2s.h"
#include <stdio.h>
#include <conio.h>
#include <string.h>

void main(void)

{
	/* Varaibles */
	int entry=999;
	int i;
	int MD2Mtr;

	/* Main program loop - menu, entry, action */
	do {

		/* Display Menu */
		printf("\n\n\n\n");
		printf("\nMD-2 Dual Stepper Motor System         Status: %c",MD2Status);
		printf("\nMD2QC2E1.C example program using MD2QC2S.C level 2 subroutine library");
		printf("\n 0 - Quit");
		printf("\n 1 - Setup");
		printf("\n 2 - Calibrate");
		printf("\n 3 - MD-2 on");
		printf("\n 4 - MD-2 off");
		printf("\n 5 - Load parameters");
		printf("\n 6 - Save parameters");
		printf("\n 7 - Display calibration values");
		printf("\n 8 - Display parameters");
		printf("\n 9 - Home move");
		printf("\n10 - Line move");
		printf("\n11 - Circle move");
		printf("\n12 - Grid move");
		printf("\n13 - Display inputs");
		printf("\n14 - Control outputs");
		printf("\n15 - Standby mode on");
		printf("\n16 - Standby mode off");
		printf("\n20 - Move test");
		printf("\n21 - Circle test");
		printf("\n22 - Grid test");

		printf("\n\nEnter selection: ");
		scanf("%i",&entry);

		/* Act according to key press */

		/* Test */
		if (entry == 20) {

			strcpy(MD2CalFile, "md2.cal");
			MD2Setup();

			/* Load parameters */
			strcpy(MD2ParFile, "Motor.Par");
			MD2ParLoad();

			/* Turn on MD-2 systems */
			MD2Motor = 34;
			MD2On();
			MD2Motor = 56;
			MD2On();

			/* Move all motors home */
			MD2Motor = 3;
			MD2Home();
			MD2Motor = 4;
			MD2Home();
			MD2Motor = 5;
			MD2Home();
			MD2Motor = 6;
			MD2Home();

			/* Move around */
			MD2Motor=3; MD2Target[3]=4; MD2Move();
			MD2Motor=4; MD2Target[4]=6; MD2Move();

			/* Down, grip, up */
			MD2Motor=5; MD2Target[5]=1.5; MD2Move();
			MD2Motor=6; MD2Target[6]=1; MD2Move();
			MD2Motor=5; MD2Target[5]=0; MD2Move();

			/* move */
			MD2Motor=34; MD2Target[3]=1; MD2Target[4]=8; MD2Move();
			MD2Motor=34; MD2Target[3]=2; MD2Target[4]=2; MD2Move();
			MD2Motor=34; MD2Target[3]=4; MD2Target[4]=6; MD2Move();

			/* Down, ungrip, up */
			MD2Motor=5; MD2Target[5]=1.5; MD2Move();
			MD2Motor=6; MD2Target[6]=0; MD2Move();
			MD2Motor=5; MD2Target[5]=0; MD2Move();

			/* move */
			MD2Motor=34; MD2Target[3]=0; MD2Target[4]=0; MD2Move();

			/* Turn off MD-2 systems */
			MD2Motor = 34;
			MD2Off();
			MD2Motor = 56;
			MD2Off();
		}

		/* Circle test */
		if (entry == 21) {

			strcpy(MD2CalFile, "md2.cal");
			MD2Setup();

			/* Load parameters */
			strcpy(MD2ParFile, "Motor.Par");
			MD2ParLoad();

			/* Turn on MD-2 systems */
			MD2Motor = 34;
			MD2On();

			/* Move all motors home */
			MD2Motor = 3;
			MD2Home();
			MD2Motor = 4;
			MD2Home();

			/* Circle */
			MD2CircleCenterX = 2.0;
			MD2CircleCenterY = 2.0;
			MD2CircleRadiusX = 1.0;
			MD2CircleRadiusY = 1.0;
			MD2CircleStart = 0;
			MD2CircleArc = 360;
			MD2CircleChord = 1;
			MD2Motor = 34;
			MD2MoveType = 'A';
			MD2Circle();

			/* Turn off MD-2 systems */
			MD2Motor = 34;
			MD2Off();
		}

		/* Grid test */
		if (entry == 22) {

			strcpy(MD2CalFile, "md2.cal");
			MD2Setup();

			/* Load parameters */
			strcpy(MD2ParFile, "Motor.Par");
			MD2ParLoad();

			/* Turn on MD-2 systems */
			MD2Motor = 34;
			MD2On();

			/* Move all motors home */
			MD2Motor = 3;
			MD2Home();
			MD2Motor = 4;
			MD2Home();

			/* Grid */
			MD2GridBeginX = 2.0;
			MD2GridBeginY = 2.0;
			MD2GridSpaceX = 1.0;
			MD2GridSpaceY = 1.0;
			MD2GridTargetX = 2;
			MD2GridTargetY = 2;
			MD2Motor = 34;
			MD2Grid();

			/* Turn off MD-2 systems */
			MD2Motor = 34;
			MD2Off();
		}

		/* Setup */
		if (entry == 1) {
			MD2Setup();
		}

		/* Calibrate */
		if (entry == 2) {
			printf("\n\nCalibrating, Please wait . . . ");
			MD2Calibrate();
		}

		/* MD-2 on */
		if (entry == 3) {
			printf("\nEnter motor pair (12,34,56) ");
			scanf("%i",&MD2Motor);
			MD2On();
		}

		/* MD-2 off */
		if (entry == 4) {
			printf("\nEnter motor pair (12,34,56) ");
			scanf("%i",&MD2Motor);
			MD2Off();
		}

		/* MD-2 load parameters */
		if (entry == 5) {
			printf("\nEnter parameter file name ");
			scanf("%s",&MD2ParFile);
			MD2ParLoad();
		}

		/* MD-2 save parameters */
		if (entry == 6) {
			printf("\nEnter parameter file name ");
			scanf("%s",&MD2ParFile);
			MD2ParSave();
		}

		/* Display calibration values */
		if (entry == 7) {
			printf("Calibration Arrays");
			for (i=1; i<25; i=i+1)
				printf("\n#%i\tDelay: %li\tVelocity: %lf ", i, MD2Delay[i], MD2Velocity[i]);
			printf("   Press ENTER ");
			scanf("%c",&i);
		}

		/* Display parameters */
		if (entry == 8) {

			/* Motor parameter arrays */
			for( MD2Mtr = 1; MD2Mtr < 7; MD2Mtr++ ) {

				printf("\n\nMotor %i Parameters\n\n",MD2Mtr);
				printf("  MD2Backlash[%i]: %lf\n",MD2Mtr,MD2Backlash[MD2Mtr]);
				printf("   MD2HomeDir[%i]: %i\n",MD2Mtr,MD2HomeDir[MD2Mtr]);
				printf("MD2HomeOffset[%i]: %lf\n",MD2Mtr,MD2HomeOffset[MD2Mtr]);
				printf("    MD2LimitF[%i]: %lf\n",MD2Mtr,MD2LimitF[MD2Mtr]);
				printf("    MD2LimitR[%i]: %lf\n",MD2Mtr,MD2LimitR[MD2Mtr]);
				printf("  MD2MaxSpeed[%i]: %lf\n",MD2Mtr,MD2MaxSpeed[MD2Mtr]);
				printf("  MD2MinSpeed[%i]: %lf\n",MD2Mtr,MD2MinSpeed[MD2Mtr]);
				printf(" MD2MotorName[%i]: %s\n",MD2Mtr,MD2MotorName[MD2Mtr]);
				printf("  MD2Position[%i]: %lf\n",MD2Mtr,MD2Position[MD2Mtr]);
				printf("     MD2Slope[%i]: %lf\n",MD2Mtr,MD2Slope[MD2Mtr]);
				printf("    MD2Target[%i]: %lf\n",MD2Mtr,MD2Target[MD2Mtr]);
				printf("     MD2Units[%i]: %i\n",MD2Mtr,MD2Units[MD2Mtr]);
				printf("  MD2UnitName[%i]: %s\n",MD2Mtr,MD2UnitName[MD2Mtr]);

				/* Press Enter */
				printf("\n\n\n\n\n\n\nPress ENTER ");
				scanf("%c",&i);
			}

			/* Misc parameters */
			printf("\nMisc Parameters\n");
			printf("\t       MD2Hold: %i - ", MD2Hold);
			if (MD2Hold == 0) printf("No\n"); else printf("Yes\n");
			printf("\t MD2Interrupts: %i - ", MD2Interrupts);
			if (MD2Interrupts == 0) printf("Off\n"); else printf("On\n");
			printf("\t      MD2Motor: %i\n", MD2Motor);
			printf("\t   MD2MoveType: %c - ", MD2MoveType);
			if (MD2MoveType == 'A') printf("Absolute");
			if (MD2MoveType == 'R') printf("Relative");
			printf("\n\t   MD2StepType: %c - ", MD2StepType);
			if (MD2StepType == 'H') printf("Half");
			if (MD2StepType == 'D') printf("Double full");
			if (MD2StepType == 'S') printf("Single full");

			/* Grid parameters */
			printf("\n\nGrid Parameters\n");
			printf("\t MD2GridBeginX: %lf\n", MD2GridBeginX);
			printf("\t MD2GridBeginY: %lf\n", MD2GridBeginY);
			printf("\t MD2GridSpaceX: %lf\n", MD2GridSpaceX);
			printf("\t MD2GridSpaceY: %lf\n", MD2GridSpaceY);
			printf("\tMD2GridTargetX: %i\n", MD2GridTargetX);
			printf("\tMD2GridTargetY: %i\n", MD2GridTargetY);

			/* Circle parameters */
			printf("\nCircle Parameters\n");
			printf("\tMD2CircleRadiusX: %lf\n", MD2CircleRadiusX);
			printf("\tMD2CircleRadiusY: %lf\n", MD2CircleRadiusY);
			printf("\tMD2CircleCenterX: %lf\n", MD2CircleCenterX);
			printf("\tMD2CircleCenterY: %lf\n", MD2CircleCenterY);
			printf("\t  MD2CircleStart: %i\n", MD2CircleStart);
			printf("\t    MD2CircleArc: %i\n", MD2CircleArc);
			printf("\t  MD2CircleChord: %i\n", MD2CircleChord);

			/* Press Enter */
			printf("\nPress ENTER ");
			scanf("%c",&i);

		}

		/* Home move */
		if (entry == 9) {
			printf("\nEnter motor # (1-6) ");
			scanf("%i",&MD2Motor);
			MD2Home();
		}

		/* Line move */
		if (entry == 10) {
			printf("\nEnter motor # (1-6) ");
			scanf("%i",&MD2Motor);
			printf("\nEnter target distance & direction ");
			scanf("%lf",&MD2Target[MD2Motor]);
			MD2MoveType = 'R';
			MD2Move();
		}

		/* Circle move */
		if (entry == 11) {
			printf("\nEnter motor pair (12,34,56) ");
			scanf("%i",&MD2Motor);
			MD2Circle();
		}

		/* Grid move */
		if (entry == 12) {
			printf("\nEnter motor pair (12,34,56) ");
			scanf("%i",&MD2Motor);
			printf("\nEnter X target ");
			scanf("%i",&MD2GridTargetX);
			printf("\nEnter Y target ");
			scanf("%i",&MD2GridTargetY);
			MD2Grid();
		}

		/* Display inputs */
		if (entry == 13) {
			MD2Inputs();
			printf("\nMD-2 #1,  home #1: %i",MD2Input[11]);
			printf("\nMD-2 #1,  home #2: %i",MD2Input[12]);
			printf("\nMD-2 #1, input #1: %i",MD2Input[13]);
			printf("\nMD-2 #1, input #2: %i",MD2Input[14]);
			printf("\nMD-2 #1, input #3: %i",MD2Input[15]);

			printf("\nMD-2 #2,  home #1: %i",MD2Input[21]);
			printf("\nMD-2 #2,  home #2: %i",MD2Input[22]);
			printf("\nMD-2 #2, input #1: %i",MD2Input[23]);
			printf("\nMD-2 #2, input #2: %i",MD2Input[24]);
			printf("\nMD-2 #2, input #3: %i",MD2Input[25]);

			printf("\nMD-2 #3,  home #1: %i",MD2Input[31]);
			printf("\nMD-2 #3,  home #2: %i",MD2Input[32]);
			printf("\nMD-2 #3, input #1: %i",MD2Input[33]);
			printf("\nMD-2 #3, input #2: %i",MD2Input[34]);
			printf("\nMD-2 #3, input #3: %i",MD2Input[35]);

			/* Press Enter */
			printf("\n\nPress ENTER ");
			scanf("%c",&i);

		}

		/* Control outputs */
		if (entry == 14) {
			printf("\nEnter MD2OutputCode ");
			scanf("%i",&MD2OutputCode);
			MD2Outputs();
		}

		/* Standby on */
		if (entry == 15) {
			printf("\nEnter motor pair (12,34,56) ");
			scanf("%i",&MD2Motor);
			MD2StandbyOn();
		}

		/* Standby off */
		if (entry == 16) {
			printf("\nEnter motor pair (12,34,56) ");
			scanf("%i",&MD2Motor);
			MD2StandbyOff();
		}



	/* Quit? */
	} while(entry != 0);

}
