/*  MD2QC2S.H
	MD-2 Dual Stepper Motor System
	Header file defining global motor parameters
	for level 2 subroutine library for the C language */

/* Functions prototypes */
void MD2Setup(void);        /* Initialize MD-2 system */
void MD2Calibrate(void);    /* Calibrate motor speeds */
void MD2On(void);           /* Turn ON MD-2 system */
void MD2Off(void);          /* Turn OFF MD-2 system */
void MD2StandbyOn(void);    /* Turn ON standby mode */
void MD2StandbyOff(void);   /* Turn OFF standby mode */
void MD2Home(void);         /* Move 1 motor to the home switch */
void MD2Move(void);         /* Move 1 or 2 motors */
void MD2Circle(void);       /* Move 2 motors in a circle, arc, ellipse */
void MD2Grid(void);         /* Move 2 motors to grid coordinates */
void MD2Outputs(void);      /* Control output signals */
void MD2Inputs(void);       /* Read input signals and home switches */
void MD2ParLoad(void);      /* Read parameters from a disk file */
void MD2ParSave(void);      /* Save parameters to a disk file */

/* Global motor parameters needed by programmer */
extern int MD2Available12;      /* Port 3bc for motors 1,2 is available */
extern int MD2Available34;      /* Port 3bc for motors 3,4 is available */
extern int MD2Available56;      /* Port 3bc for motors 5,6 is available */
extern double MD2Backlash[];    /* Backlash compensation in units */
extern char MD2CalFile[13];     /* Calibration file name */
extern int MD2Calibrated;       /* Calibrated -1=true, 0=false */
extern double MD2CircleRadiusX; /* Circle X radius in units */
extern double MD2CircleRadiusY; /* Circle Y radius in units */
extern double MD2CircleCenterX; /* Circle X center in units */
extern double MD2CircleCenterY; /* Circle Y center in units */
extern int MD2CircleStart;      /* Circle starting angle in degrees */
extern int MD2CircleArc;        /* Circle arc angle in degrees */
extern int MD2CircleChord;      /* Circle chord angle in degrees */
extern long int MD2Delay[25];   /* Delay array for speed control */
extern int MD2Enabled12;        /* Port 3bc for motors 1,2 turned on */
extern int MD2Enabled34;        /* Port 378 for motors 3,4 turned on */
extern int MD2Enabled56;        /* Port 278 for motors 5,6 turned on */
extern double MD2GridBeginX;    /* Grid X start position in units */
extern double MD2GridBeginY;    /* Grid Y start position in units */
extern double MD2GridSpaceX;    /* Grid X spacing in units */
extern double MD2GridSpaceY;    /* Grid Y spacing in units */
extern int MD2GridTargetX;      /* Grid X target */
extern int MD2GridTargetY;      /* Grid Y target */
extern int MD2Hold;             /* Hold motors after moves. -1=yes,0=no */
extern double MD2HomeOffset[];  /* Distance to move away from home switch */
extern int MD2HomeDir[];        /* Direction of the home switch. 0=rev,-1=fwd */
extern int MD2Input[];          /* Status of input signals and home switches */
extern int MD2Interrupts;       /* Leave COM interrupts on during moves? 0=no */
extern double MD2LimitF[];      /* Forward soft limit in units */
extern double MD2LimitR[];      /* Reverse soft limit in units */
extern int MD2Motor;            /* Selected motor or motor pair 1-6,12,34,56 */
extern char MD2MotorName[][9];  /* Motor names */
extern double MD2MaxSpeed[];    /* Speed after acceleration in units/sec */
extern double MD2MinSpeed[];    /* Start and stop speed in units/sec */
extern char MD2MoveType;        /* R=relative, A=absolute */
extern int MD2OutputCode;       /* Port,bit and status for MD2Outputs function */
extern char MD2ParFile[13];     /* Parameter file name */
extern double MD2Position[];    /* Current motor position */
extern double MD2Slope[];       /* Accel/Decel slope in units */
extern char MD2Status;          /* Completion status O=ok, B=bad parameter,
								F=file error, L=limit exceeded, K=key stop
								E=port not enabled, A=port not available. */
extern char MD2StepType;        /* H=half, D=double full, S=single full */
extern double MD2Target[];      /* # of units to move or target position */
extern long int MD2Units[];     /* # of steps in each unit */
extern char MD2UnitName[][9];   /* Name of user-definable unit */
extern double MD2Velocity[25];  /* Velocity array for speed control */
