VERSION 2.00
Begin Form md2vw2e1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "MD-2 Visual Basic Level 2 Example #1"
   ClientHeight    =   4530
   ClientLeft      =   990
   ClientTop       =   1320
   ClientWidth     =   7485
   Height          =   4935
   Icon            =   0
   Left            =   930
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4530
   ScaleWidth      =   7485
   Top             =   975
   Width           =   7605
   Begin PictureBox picCalibrating 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00C0C0C0&
      FillColor       =   &H00FFFFFF&
      FillStyle       =   0  'Solid
      FontTransparent =   0   'False
      Height          =   1935
      Left            =   1800
      ScaleHeight     =   1905
      ScaleWidth      =   3945
      TabIndex        =   52
      Top             =   1080
      Visible         =   0   'False
      Width           =   3975
      Begin Label lblCalibration 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Calibrating, please wait . . . "
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   12
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H000000FF&
         Height          =   375
         Left            =   120
         TabIndex        =   50
         Top             =   720
         Width           =   3735
      End
   End
   Begin CommandButton cmdCalibrate 
      Caption         =   "&Calibrate"
      Height          =   375
      Left            =   5640
      TabIndex        =   51
      Top             =   480
      Width           =   1215
   End
   Begin Frame Frame6 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Motor"
      Height          =   2535
      Left            =   120
      TabIndex        =   32
      Top             =   1920
      Width           =   855
      Begin OptionButton OptMotor 
         Caption         =   "&6"
         Height          =   255
         Index           =   5
         Left            =   240
         TabIndex        =   44
         Top             =   2160
         Width           =   495
      End
      Begin OptionButton OptMotor 
         Caption         =   "&5"
         Height          =   255
         Index           =   4
         Left            =   240
         TabIndex        =   43
         Top             =   1800
         Width           =   495
      End
      Begin OptionButton OptMotor 
         Caption         =   "&4"
         Height          =   255
         Index           =   3
         Left            =   240
         TabIndex        =   42
         Top             =   1440
         Width           =   495
      End
      Begin OptionButton OptMotor 
         Caption         =   "&3"
         Height          =   255
         Index           =   2
         Left            =   240
         TabIndex        =   41
         Top             =   1080
         Width           =   495
      End
      Begin OptionButton OptMotor 
         Caption         =   "&2"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   40
         Top             =   720
         Width           =   495
      End
      Begin OptionButton OptMotor 
         Caption         =   "&1"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   33
         Top             =   360
         Width           =   495
      End
   End
   Begin CommandButton CmdReverse 
      Caption         =   "&Reverse"
      Height          =   375
      Left            =   3960
      TabIndex        =   34
      Top             =   720
      Width           =   1335
   End
   Begin Frame Frame5 
      Caption         =   "MinSpeed"
      Height          =   2535
      Left            =   960
      TabIndex        =   30
      Top             =   1920
      Width           =   1335
      Begin TextBox TxTMinSpeed 
         Height          =   285
         Index           =   5
         Left            =   240
         TabIndex        =   35
         Top             =   2160
         Width           =   855
      End
      Begin TextBox TxTMinSpeed 
         Height          =   285
         Index           =   4
         Left            =   240
         TabIndex        =   36
         Top             =   1800
         Width           =   855
      End
      Begin TextBox TxTMinSpeed 
         Height          =   285
         Index           =   3
         Left            =   240
         TabIndex        =   37
         Top             =   1440
         Width           =   855
      End
      Begin TextBox TxTMinSpeed 
         Height          =   285
         Index           =   2
         Left            =   240
         TabIndex        =   39
         Top             =   1080
         Width           =   855
      End
      Begin TextBox TxTMinSpeed 
         Height          =   285
         Index           =   1
         Left            =   240
         TabIndex        =   38
         Top             =   720
         Width           =   855
      End
      Begin TextBox TxTMinSpeed 
         Height          =   285
         Index           =   0
         Left            =   240
         TabIndex        =   31
         Top             =   360
         Width           =   855
      End
   End
   Begin Frame Frame1 
      Caption         =   "Slope"
      Height          =   2535
      Left            =   2280
      TabIndex        =   23
      Top             =   1920
      Width           =   855
      Begin TextBox TxtSlope 
         Height          =   285
         Index           =   5
         Left            =   120
         TabIndex        =   29
         Top             =   2160
         Width           =   615
      End
      Begin TextBox TxtSlope 
         Height          =   285
         Index           =   4
         Left            =   120
         TabIndex        =   28
         Top             =   1800
         Width           =   615
      End
      Begin TextBox TxtSlope 
         Height          =   285
         Index           =   3
         Left            =   120
         TabIndex        =   27
         Top             =   1440
         Width           =   615
      End
      Begin TextBox TxtSlope 
         Height          =   285
         Index           =   2
         Left            =   120
         TabIndex        =   26
         Top             =   1080
         Width           =   615
      End
      Begin TextBox TxtSlope 
         Height          =   285
         Index           =   1
         Left            =   120
         TabIndex        =   25
         Top             =   720
         Width           =   615
      End
      Begin TextBox TxtSlope 
         Height          =   285
         Index           =   0
         Left            =   120
         TabIndex        =   24
         Top             =   360
         Width           =   615
      End
   End
   Begin Frame Frame4 
      Caption         =   "Distance"
      Height          =   2535
      Left            =   4440
      TabIndex        =   21
      Top             =   1920
      Width           =   1335
      Begin TextBox TxtDistance 
         Height          =   285
         Index           =   5
         Left            =   120
         TabIndex        =   49
         Top             =   2160
         Width           =   1095
      End
      Begin TextBox TxtDistance 
         Height          =   285
         Index           =   4
         Left            =   120
         TabIndex        =   48
         Top             =   1800
         Width           =   1095
      End
      Begin TextBox TxtDistance 
         Height          =   285
         Index           =   3
         Left            =   120
         TabIndex        =   47
         Top             =   1440
         Width           =   1095
      End
      Begin TextBox TxtDistance 
         Height          =   285
         Index           =   2
         Left            =   120
         TabIndex        =   46
         Top             =   1080
         Width           =   1095
      End
      Begin TextBox TxtDistance 
         Height          =   285
         Index           =   1
         Left            =   120
         TabIndex        =   45
         Top             =   720
         Width           =   1095
      End
      Begin TextBox TxtDistance 
         Height          =   285
         Index           =   0
         Left            =   120
         TabIndex        =   22
         Top             =   360
         Width           =   1095
      End
   End
   Begin Frame Frame3 
      Caption         =   "MaxSpeed"
      Height          =   2535
      Left            =   3120
      TabIndex        =   14
      Top             =   1920
      Width           =   1335
      Begin TextBox TxtMaxspeed 
         Height          =   285
         Index           =   5
         Left            =   240
         TabIndex        =   20
         Top             =   2160
         Width           =   855
      End
      Begin TextBox TxtMaxspeed 
         Height          =   285
         Index           =   4
         Left            =   240
         TabIndex        =   19
         Top             =   1800
         Width           =   855
      End
      Begin TextBox TxtMaxspeed 
         Height          =   285
         Index           =   3
         Left            =   240
         TabIndex        =   18
         Top             =   1440
         Width           =   855
      End
      Begin TextBox TxtMaxspeed 
         Height          =   285
         Index           =   2
         Left            =   240
         TabIndex        =   17
         Top             =   1080
         Width           =   855
      End
      Begin TextBox TxtMaxspeed 
         Height          =   285
         Index           =   1
         Left            =   240
         TabIndex        =   16
         Top             =   720
         Width           =   855
      End
      Begin TextBox TxtMaxspeed 
         Height          =   285
         Index           =   0
         Left            =   240
         TabIndex        =   15
         Top             =   360
         Width           =   855
      End
   End
   Begin CheckBox ChkHold 
      Caption         =   "Hol&d motors after moves"
      Height          =   255
      Left            =   600
      TabIndex        =   7
      Top             =   1440
      Width           =   2415
   End
   Begin CheckBox ChkInterrupts 
      Caption         =   "Leave &Interrupts on during moves"
      Height          =   255
      Left            =   3960
      TabIndex        =   6
      Top             =   1440
      Width           =   3135
   End
   Begin Frame Frame2 
      Caption         =   "Position"
      Height          =   2535
      Left            =   5760
      TabIndex        =   5
      Top             =   1920
      Width           =   1575
      Begin TextBox TxtPosition 
         Height          =   285
         Index           =   5
         Left            =   120
         TabIndex        =   13
         Top             =   2160
         Width           =   1335
      End
      Begin TextBox TxtPosition 
         Height          =   285
         Index           =   4
         Left            =   120
         TabIndex        =   12
         Top             =   1800
         Width           =   1335
      End
      Begin TextBox TxtPosition 
         Height          =   285
         Index           =   3
         Left            =   120
         TabIndex        =   11
         Top             =   1440
         Width           =   1335
      End
      Begin TextBox TxtPosition 
         Height          =   285
         Index           =   2
         Left            =   120
         TabIndex        =   10
         Top             =   1080
         Width           =   1335
      End
      Begin TextBox TxtPosition 
         Height          =   285
         Index           =   1
         Left            =   120
         TabIndex        =   9
         Top             =   720
         Width           =   1335
      End
      Begin TextBox TxtPosition 
         Height          =   285
         Index           =   0
         Left            =   120
         TabIndex        =   8
         Top             =   360
         Width           =   1335
      End
   End
   Begin CommandButton CmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   2280
      TabIndex        =   4
      Top             =   720
      Width           =   1335
   End
   Begin CommandButton CmdHome 
      Caption         =   "&Home Motor"
      Height          =   375
      Left            =   2280
      TabIndex        =   3
      Top             =   240
      Width           =   1335
   End
   Begin CommandButton CmdForward 
      Caption         =   "&Forward"
      Height          =   375
      Left            =   3960
      TabIndex        =   2
      Top             =   240
      Width           =   1335
   End
   Begin CommandButton CmdOff 
      Caption         =   "MD-2  &Off"
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   720
      Width           =   1335
   End
   Begin CommandButton CmdOn 
      Caption         =   "MD-2 O&n"
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   240
      Width           =   1335
   End
End
Option Explicit

'Module level variables.
Dim Direction As String

Sub cmdCalibrate_Click ()

    'Calibrate.
    If MsgBox("Calibration takes 10 minutes", 4096 + 32 + 1, "Calibration") = 1 Then
        picCalibrating.Visible = True
        lblCalibration.Refresh
        MD2CALIBRATE
        picCalibrating.Visible = False
        Beep
    End If
    
End Sub

Sub CmdExit_Click ()
    
    End

End Sub

Sub CmdForward_Click ()
    
    'Move a motor forward.
    Direction = "F"
    SetParameters
    MD2MOVE
    ShowError
    UpdateScreen

End Sub

Sub CmdHome_Click ()
    
    'Home the motor.
    Direction = "F"
    SetParameters
    MD2HOME
    ShowError
    UpdateScreen
    
End Sub

Sub CmdOff_Click ()

    'Turn off MD-2.
    SetParameters
    MD2OFF

End Sub

Sub CmdOn_Click ()

    'Turn on an MD-2.
    SetParameters
    MD2ON

End Sub

Sub CmdReverse_Click ()

    'Move a motor reverse.
    Direction = "R"
    SetParameters
    MD2MOVE
    ShowError
    UpdateScreen

End Sub

Sub Form_Load ()

    'Set motor default parameters, read calibration.
    MD2SETUP
    
    'Update screen objects
    UpdateScreen

    'Turn off calibrating message.
    picCalibrating.Visible = False

End Sub

Sub Form_Unload (Cancel As Integer)
    
    End

End Sub

Sub SetParameters ()

    'Set MD-2 parameters according to form objects.

    'Local variables.
    Dim i As Integer

    'Set MD2HOLD.
    If chkHold.Value = False Then MD2HOLD = False Else MD2HOLD = True
    
    'Set MD2INTERRUPTS.
    If chkInterrupts.Value = False Then MD2INTERRUPTS = False Else MD2INTERRUPTS = True

    'Set other parameters.
    For i = 1 To 6
        If OptMotor(i - 1) Then MD2MOTOR = i
        MD2MINSPEED(i) = Val(TxtMinSpeed(i - 1).Text)
        MD2MAXSPEED(i) = Val(TxtMaxSpeed(i - 1).Text)
        MD2SLOPE(i) = Val(TxtSlope(i - 1).Text)
        If Direction = "F" Then
            'Forward.
            MD2TARGET(i) = Abs(Val(TxtDistance(i - 1).Text))
        Else
            'Reverse.
            MD2TARGET(i) = Abs(Val(TxtDistance(i - 1).Text)) * -1
        End If
    Next i

End Sub

Sub ShowError ()

    'Show error.

    'Local Variables.
    Dim message As String

    'Create message.
    If MD2STATUS = "O" Then Exit Sub
    If MD2STATUS = "B" Then message = "Bad parameter"
    If MD2STATUS = "L" Then message = "Limit exceeded"
    If MD2STATUS = "F" Then message = "File error"
    If MD2STATUS = "P" Then message = "Port is not available"
    If MD2STATUS = "E" Then message = "MD-2 is not ON"
    If MD2STATUS = "C" Then message = "Need calibration"
    If MD2STATUS = "S" Then message = "Need setup"
    If MD2STATUS = "K" Then message = "Keypress stopped motion"

    'Display message
    MsgBox message, 0, "Error"

    'Do again if keypress.
    If MD2STATUS = "K" Then MsgBox message, 0, "Error"
    
End Sub

Sub UpdateScreen ()

    'Set screen objects according to MD-2 parameters.
    
    'Local variables.
    Dim i As Integer

    For i = 1 To 6
        If MD2MOTOR = i Then OptMotor(i - 1).Value = True Else OptMotor(i - 1).Value = False
        TxtPosition(i - 1).Text = Str$(MD2POSITION(i))
        TxtMaxSpeed(i - 1).Text = Str$(MD2MAXSPEED(i))
        TxtMinSpeed(i - 1).Text = Str$(MD2MINSPEED(i))
        TxtSlope(i - 1).Text = Str$(MD2SLOPE(i))
        TxtDistance(i - 1).Text = Str$(Abs(MD2TARGET(i)))
    Next i

    If MD2HOLD = False Then chkHold.Value = 0 Else chkHold.Value = 1
    If MD2INTERRUPTS = False Then chkInterrupts.Value = 0 Else chkInterrupts.Value = 1
        
End Sub

