Imports System.IO

Public Class FormC4
    'Public debugit As New StreamWriter("debugfile.txt", False)
    Public SelectedC4HexFile As String  'C4 hex file for firmware update.
    Private Sub FormC4_load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'Set update instructions because during update they are changed.
        LabelC4UpdateMessage.ForeColor = Color.Black
        LabelC4UpdateMessage.Text = "1. Download file from ArrickRobotics.com to Desktop." & vbCrLf
        LabelC4UpdateMessage.Text += "2. Select file with the Select File button." & vbCrLf
        LabelC4UpdateMessage.Text += "3. Click the Update C4 button."

        'Load COM ports
        For i As Integer = 0 To _
           My.Computer.Ports.SerialPortNames.Count - 1
            ComboBoxC4Port.Items.Add(My.Computer.Ports.SerialPortNames(i))
        Next
        ComboBoxC4Port.SelectedIndex = 0

        'debug  ComboBoxC4Port.Items.Add("COM44")

        'Load C4 IDs
        For i As Integer = 1 To 9
            ComboBoxC4ID.Items.Add(i)
        Next
        ComboBoxC4ID.SelectedIndex = 0

        'DISABLE ALL MD2S.
        MD2MOTOR = 1
        MD2OFF()
        MD2MOTOR = 3
        MD2OFF()
        MD2MOTOR = 5
        MD2OFF()

    End Sub
    Public Sub ButtonC4Check_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonC4Check.Click

        'Turn off receive update timer.
        TimerC4.Stop()

        'Check C4 communications by getting product/version data.
        FormPorts.TestC4Port(ComboBoxC4Port.SelectedItem, ComboBoxC4ID.SelectedItem)

    End Sub
    Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOK.Click

        'Turn off receive update timer.
        TimerC4.Stop()

        'Close serial port if open
        FormPorts.CloseComPort()

        'Close form.
        Me.Close()
        Me.Dispose()
        'debugit.Close()

    End Sub
    Private Sub TextBoxC4_Enter(ByVal sender As Object, ByVal e As System.EventArgs) Handles TextBoxC4.Enter

        'Open com port
        If FormPorts.OpenComPort(ComboBoxC4Port.SelectedItem, True) Then

            'Start timer to update received text
            TimerC4.Start()

        End If

    End Sub
    Private Sub TimerC4_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TimerC4.Tick

        'If any characters, display on text box
        'And fix CR/LF displaying little block.
        Try
            TextBoxC4.AppendText(MD2xp.C4Port.ReadExisting.Replace(Chr(13), vbCrLf))
        Catch ex As Exception
            'Ignore if can't read serial port
        End Try

    End Sub
    Private Sub FormC4_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Me.KeyPress

        Try
            MD2xp.C4Port.Write(e.KeyChar)        'Send character to C4.
        Catch ex As Exception
            'Probably caused by changing form focus and port got closed. Reopen.
            FormPorts.OpenComPort(ComboBoxC4Port.SelectedItem, True)
        End Try

    End Sub
    Private Sub ButtonSetID_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSetID.Click

        Dim msg As String

        msg = "Are you sure you wish to set C4's ID to " & ComboBoxC4ID.SelectedItem & " ?"
        msg += vbCrLf & vbCrLf
        msg += "Make sure only one C4 Controller is connected to " & MD2xp.C4Port.PortName

        'Confirm with user to set ID.
        If MessageBox.Show(msg, "Confirm ID Set", MessageBoxButtons.OKCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) = Windows.Forms.DialogResult.OK Then

            'Set ID
            If FormPorts.OpenComPort(ComboBoxC4Port.SelectedItem, True) Then

                'First, deal with possibility of ID set to 0 (no ID).
                MD2xp.C4Port.Write("wi1" & vbCr)
                Threading.Thread.Sleep(100)
                msg = MD2xp.C4Port.ReadExisting     'Ignore result.

                'Send command to set id to everyone on the line (!!), should be only one.
                MD2xp.C4Port.Write("!!wi" & ComboBoxC4ID.SelectedItem & vbCr)

                'Read response
                Threading.Thread.Sleep(100)
                msg = MD2xp.C4Port.ReadExisting
                If msg <> "a" Then

                    'Not 'a', tell user
                    MsgBox("ID Set Response is " & msg)

                Else

                    'Confirmed.
                    MsgBox("ID Set")

                End If

            End If

        End If

    End Sub
    Private Sub FormC4_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.LostFocus, Me.Leave, Me.Deactivate

        'LostFocus,Leave,Deactivate
        'Close port if user goes to another form to do something.
        'debug FormPorts.CloseComPort()

    End Sub
    Private Sub ButtonC4Browse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonC4Browse.Click

        'Setup the open file dialog box
        OpenFileDialogC4.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Desktop)
        OpenFileDialogC4.Title = "Select C4.hex for C4 Firmware Update"
        OpenFileDialogC4.FileName = ""       'Must be cleared or will return object name!
        OpenFileDialogC4.Filter = "C4 hex File (*.hex)|*.hex|All files (*.*)|*.*"
        OpenFileDialogC4.FilterIndex = 1     'Default filter.

        'Display the open file dialog box.
        OpenFileDialogC4.ShowDialog()

        'Load.
        If OpenFileDialogC4.FileName <> "" Then
            SelectedC4HexFile = OpenFileDialogC4.FileName       'Set file name.
            'MD2PARLOAD()                                'Load parameters.
            'SetForms()                                  'Update forms with parameters.
            'SetDistances()                              'Update forms with parameters.
            'LabelParameterFile.Text = MD2PARFILE        'Update the file name label.
            'ParametersUnsaved = False                   'Unsaved flag.
        End If

        'debug TextBoxC4.AppendText(vbCrLf & "Hex File: " & SelectedC4HexFile & vbCrLf)

    End Sub
    Private Sub ButtonC4Update_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonC4Update.Click

        'Upload selected firmware .hex file to C4.
        'Upon power up, C4 jumps to bootloader.  
        'If it doesn't get a ESC within a few seconds it jumps to 0 and runs the app code.
        'Otherwise it stays in bootloader code ready to accept download. 
        'See Atmel AVR109 application note for protocol.
        'E exits from bootloader and jumps to 0.
        'If the app code is running, an 'fu' command will jump to the bootloader.
        'If hex file has 's.hex' in filename, then is scrambled, use 'Z' command to turn on unscrambling, 'z' turns off.
        'Intel hex file data.  
        '  ex:   :100000000C9416010C9431010C9431010C943101C3
        '  Colon, 2-char hex record length (10), 4-char hex address (0000), 2-char record type (00=data, 01=eof),
        '  String 2-char hex data bytes, checksum as 2-char hex (C3).

        Dim I As Integer                        'Temp integer.
        Dim S As String                         'Temp string.
        Dim B As Byte() = New Byte(1) {}        'Required to write binary bytes to serial port.
        Dim PROGRESS As Integer                 'Progress countdown 10,9,8
        Dim IHFILE As StreamReader              'Intel hex file object.
        Dim IHDATA As String                    'Intel hex data (entire file).
        Dim IHPTR As Integer                    'Intel hex pointer to data.
        Dim IHRECORDLENGTH As Integer           'Intel hex length of current record.
        Dim IHRECORDTYPE As Integer = 0         'Intel hex type of current record.
        Dim IHBYTE As Integer                   'Intel hex file current byte.
        Dim IHADDRESS As Integer                'Intel hex file address of current byte.
        Dim IHCOUNT As Integer                  'Intel hex total byte counter.
        Dim PAGESIZE As Integer = 256           'Page size of AVR ATMEGA644p
        Dim PAGEBYTES As Integer = 0            '# of bytes saved to current page.
        Dim PAGEADDRESS As Integer              'Address of current page in AVR.

        'Open hex file, read entire file.
        Try
            'If file not selected, default to c4.hex.
            If SelectedC4HexFile = "" Then SelectedC4HexFile = Environment.GetFolderPath(Environment.SpecialFolder.Desktop) & "\c4.hex"
            IHFILE = New StreamReader(SelectedC4HexFile)
            IHDATA = IHFILE.ReadToEnd
            IHFILE.Close()
        Catch ex As Exception
            'Deal with error.
            S = "Error reading C4 hex file" & vbCrLf & SelectedC4HexFile
            MessageBox.Show(S, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
            Exit Sub
        End Try

        'Check for valid hex file.
        If IHDATA.Substring(0, 1) <> ":" Then
            MessageBox.Show("Hex file data does not begin with a colon", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
            Exit Sub
        End If
        If IHDATA.Substring(7, 1) <> "0" Then
            MessageBox.Show("Invalid record type in hex file data", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1)
            Exit Sub
        End If

        'Updating message.
        LabelC4UpdateMessage.ForeColor = Color.Red
        LabelC4UpdateMessage.Text = "Updating C4 firmware . . ."
        Application.DoEvents()                          'Force display of message text.

        'Upload the hex file.

        Try
            'Open port - throw error if error
            If Not FormPorts.OpenComPort(ComboBoxC4Port.SelectedItem, False) Then Throw New ArgumentException("System.DevideByZeroException")

            'Get into bootloader
            Do
                I = InBootloader()                      'Get bootloader version or 0 if not in bootloader.
                'If not in bootloader,
                If I = 0 Then

                    'Must be in app code - send command to jump to bootloader.
                    MD2xp.C4Port.DiscardInBuffer()      'Clear serial buffer.
                    MD2xp.C4Port.Write(Chr(&H1B) & "!" & ComboBoxC4ID.SelectedItem & "fu" & vbCr)   'Send Firmware Update command.
                    LabelC4UpdateMessage.Text += " ."   'This indicates jump from app code to bootloader.
                    Application.DoEvents()              'Force update of label text.
                    Threading.Thread.Sleep(400)         'Short wait.
                    MD2xp.C4Port.Write(Chr(&H1B))       'This ESC tells bootloader to start.
                    Threading.Thread.Sleep(200)         'Short wait.
                    MD2xp.C4Port.DiscardInBuffer()      'Clear out any junk in serial buffer.

                    I = InBootloader()                  'Check if in bootloader now.

                    'If not in bootloader,
                    If I = 0 Then
                        'Still not in bootloader, must have trashed app code, send message.
                        S = "To start C4 Firmware update:" & vbCrLf
                        S += "Power C4 off, then back on," & vbCrLf
                        S += "Then press OK within 2 seconds"
                        If MessageBox.Show(S, "Power Cycle C4 Required", MessageBoxButtons.OKCancel, MessageBoxIcon.None) = Windows.Forms.DialogResult.OK Then
                            Continue Do
                        Else
                            'User canceled.
                            Exit Sub
                        End If
                    Else
                        'In bootloader
                        Exit Do
                    End If
                Else
                    'In bootloader
                    Exit Do
                End If
            Loop

            'Hourglass Cursor.
            Me.Cursor = Cursors.WaitCursor

            'In bootloader, display version.
            LabelC4UpdateMessage.Text += vbCrLf & "Bootloader V" & I.ToString.Substring(0, 1) & "." & I.ToString.Substring(1, 1)
            Application.DoEvents()                  'Force update of label text.

            'Erase C4 app code.
            LabelC4UpdateMessage.Text += "  Erasing"
            Application.DoEvents()                  'Force update of label text.
            UPROG("Erasing")
            MD2xp.C4Port.Write("e")                 'Send e command.
            S = MD2xp.C4Port.ReadByte               'Wait for CR means erase done.
            LabelC4UpdateMessage.Text += "-done"
            Application.DoEvents()                  'Force update of label text.
            UPROG("-done")

            'If hex file has 's.hex' in filename, then is scrambled, use 'Z' command to turn on unscrambling, 'z' turns off.
            If SelectedC4HexFile.Contains("s.hex") Then
                MD2xp.C4Port.Write("Z")                 'Turn on descrambling.
            Else
                MD2xp.C4Port.Write("z")                 'Turn off descrambling.
            End If
            S = MD2xp.C4Port.ReadByte                   'Wait for CR means done.

            'Begin reading hex data, building blocks, sending to C4
            LabelC4UpdateMessage.Text += vbCrLf & "Progress: "
            Application.DoEvents()                  'Force update of label text.
            PROGRESS = 10           'Progress countdown counter.
            IHPTR = 0               'Pointer to hex data.!1fu
            IHCOUNT = 0             'Bytes sent to C4.

            Do
                'End of hex file?
                If IHPTR >= IHDATA.Length Then Exit Do

                'Get next byte from hex file with address.

                'If : then start of hex line -- read record length, read address, record type
                If IHDATA(IHPTR) = ":" Then
                    UPROG(vbCrLf & ": ")
                    IHPTR += 1      'Point to first byte of record length.

                    'Get record length (# of bytes)  2 hex characters.
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S = IHDATA(IHPTR)  'First char.
                    IHPTR += 1
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S += IHDATA(IHPTR) 'Second char.
                    IHPTR += 1
                    IHRECORDLENGTH = Convert.ToInt32(S, 16)
                    UPROG(Hex(IHRECORDLENGTH).PadLeft(2, "0"c) & " ")

                    'Get address, 4 hex characters.
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S = IHDATA(IHPTR)  'First char.
                    IHPTR += 1
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S += IHDATA(IHPTR) 'Second char.
                    IHPTR += 1
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S += IHDATA(IHPTR) 'Second char.
                    IHPTR += 1
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S += IHDATA(IHPTR) 'Second char.
                    IHPTR += 1
                    IHADDRESS = Convert.ToInt32(S, 16)
                    UPROG(Hex(IHADDRESS).PadLeft(4, "0"c) & " ")

                    'Get record type, 2 hex characters.  00=data, 01=eof.
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S = IHDATA(IHPTR)  'First char.
                    IHPTR += 1
                    If IHPTR >= IHDATA.Length Then Exit Do
                    S += IHDATA(IHPTR) 'Second char.
                    IHPTR += 1
                    IHRECORDTYPE = Convert.ToInt32(S, 16)
                    UPROG(Hex(IHRECORDTYPE).PadLeft(2, "0"c))

                End If

                'EOF record - probably don't need this because record type 1 has 0 recordlength.
                If IHRECORDTYPE = 1 Then
                    'If there are bytes to write, then write the page.
                    If PAGEBYTES > 0 Then
                        ACMD(PAGEADDRESS)               'Set address with A command.
                        mCMD()                          'Write page.
                    End If
                    Exit Do                             'Finished.
                End If

                'Now pointing to where data byte should be if any.

                'No more bytes in record?
                If IHRECORDLENGTH <= 0 Then
                    IHPTR += 1                          'Point to next.
                    Continue Do                         'Continue through file.
                End If

                'First byte of page or file?
                If PAGEBYTES = 0 Then
                    PAGEADDRESS = IHADDRESS             'This page's start address.
                    ACMD(PAGEADDRESS)                   'Set address with A command.
                End If

                'Get LOW data byte - 2 chars.
                S = IHDATA(IHPTR)  'First char.
                IHPTR += 1
                If IHPTR >= IHDATA.Length Then Exit Do
                S += IHDATA(IHPTR) 'Second char.
                IHPTR += 1
                IHBYTE = Convert.ToInt32(S, 16)         'Convert from hex to decimal.

                'Send c command and low byte.
                MD2xp.C4Port.Write("c")                 'Send command.
                B(0) = IHBYTE And &HFF
                MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
                S = MD2xp.C4Port.ReadByte               'Get CR back.
                UPROG(vbCrLf & "c=" & Hex(IHBYTE))

                'Get LOW data byte - 2 chars.
                S = IHDATA(IHPTR)  'First char.
                IHPTR += 1
                If IHPTR >= IHDATA.Length Then Exit Do
                S += IHDATA(IHPTR) 'Second char.
                IHPTR += 1
                IHBYTE = Convert.ToInt32(S, 16)         'Convert from hex to decimal.

                'Send C command and low byte.
                MD2xp.C4Port.Write("C")                 'Send command.
                B(0) = IHBYTE And &HFF
                MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
                S = MD2xp.C4Port.ReadByte               'Get CR back.
                UPROG(vbCrLf & "C=" & Hex(IHBYTE))

                'Update counts.
                IHRECORDLENGTH -= 2
                IHADDRESS += 2
                PAGEBYTES += 2
                IHCOUNT += 2                            'Total bytes sent to C4.

                'If last byte of page then write it.
                If PAGEBYTES = PAGESIZE Then
                    ACMD(PAGEADDRESS)                   'Set address with A command.
                    mCMD()                              'Write page.
                    PAGEBYTES = 0
                End If

                'Update progress.
                If IHPTR > (10 - PROGRESS) * (IHDATA.Length / 10) Then
                    LabelC4UpdateMessage.Text += PROGRESS.ToString & "."
                    Application.DoEvents()              'Force update of label text.
                    PROGRESS -= 1
                End If

            Loop    'next byte of hex file.

            'Complete message.
            LabelC4UpdateMessage.Text = vbCrLf & "C4 Firmware Update Complete."
            LabelC4UpdateMessage.Text += vbCrLf & IHCOUNT & " Bytes sent."
            UPROG("Done")

            'Jump to newly uploaded code.
            MD2xp.C4Port.Write("E")

        Catch ex As Exception

            'Failed message.
            UPROG(vbCrLf & "Error: " & ex.ToString)
            UPROG("Done")
            LabelC4UpdateMessage.Text = vbCrLf & "C4 Firmware Update Failed." & vbCrLf
            LabelC4UpdateMessage.Text += "Check port setting, ID, power, cable."

        End Try

        'Sound.
        My.Computer.Audio.PlaySystemSound(Media.SystemSounds.Exclamation)

        'Normal Cursor.
        Me.Cursor = Cursors.Default

    End Sub
    Private Sub mCMD()

        'm command writes page.

        Dim S As String

        MD2xp.C4Port.Write("m")                 'Send m command.
        S = MD2xp.C4Port.ReadByte               'Get CR back.
        UPROG(vbCrLf & "m ========================================")

    End Sub
    Private Sub ACMD(ByVal PAGEADDRESS As UInt16)

        'A command to set page address.

        Dim I As Integer
        Dim S As String
        Dim B As Byte() = New Byte(1) {}        'Required to write binary bytes to serial port.

        MD2xp.C4Port.Write("A")                 'Send A command.
        I = PAGEADDRESS / 2                     'Address is in words, not bytes.
        B(0) = (I And &HFF00) / &H100           'High byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        UPROG(vbCrLf & "A=" & Hex(B(0)) & " ")
        B(0) = I And &HFF                       'Low byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        S = MD2xp.C4Port.ReadByte               'Get CR back.
        UPROG(Hex(B(0)) & "-----------------")

    End Sub
    Private Sub flashverify()

        'Debug code to test reading/writing flash.

        Dim debugflash As New StreamWriter("debugflash.txt")
        debugflash.Write(vbCrLf & "Flash Memory Verify" & vbCrLf)
        debugflash.Close()

        Dim S As String = ""
        Dim T As String = ""
        Dim T1 As String = ""
        Dim B As Byte() = New Byte(1) {}
        Dim I As Int16 = 0
        Dim ADDRESS As Int16 = 0
        Dim LC As Integer = 0  'line counter.

        'Clear junk.
        MD2xp.C4Port.Write(&H1B)            'Send ESC.
        MD2xp.C4Port.Write(&H1B)            'Send ESC.
        MD2xp.C4Port.Write(&H1B)            'Send ESC.
        MD2xp.C4Port.Write(&H1B)            'Send ESC.
        Threading.Thread.Sleep(200)
        MD2xp.C4Port.DiscardInBuffer()

        'Read signature bytes.
        'MD2xp.C4Port.Write("s")                'Send s command.
        'T = MD2xp.C4Port.ReadByte
        'MsgBox(Hex(T))
        'T = MD2xp.C4Port.ReadByte
        'MsgBox(Hex(T))
        'T = MD2xp.C4Port.ReadByte
        'MsgBox(Hex(T))

        GoTo dsp 'skip write test

        'write test.

        MD2xp.C4Port.Write("e")               'Send e command.
        S = MD2xp.C4Port.ReadByte             'Wait for any character means erase done.

        'Set address (in words, address/2).
        ADDRESS = 0
        MD2xp.C4Port.Write("A")                 'Send A command.
        I = ADDRESS / 2                         'Address is in words, not bytes.
        B(0) = (I / &H100) And &HFF             'High byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        B(0) = I And &HFF                       'Low byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        T = MD2xp.C4Port.ReadByte               'Get CR back.

        'Set c command and low byte.
        MD2xp.C4Port.Write("c")                 'Send command.
        B(0) = &H33             'High byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        T = MD2xp.C4Port.ReadByte               'Get CR back.

        'Set C command and high byte.
        MD2xp.C4Port.Write("C")                 'Send command.
        B(0) = &H44                       'Low byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        T = MD2xp.C4Port.ReadByte               'Get CR back.

        MD2xp.C4Port.Write("m")                 'Send command.
        T = MD2xp.C4Port.ReadByte               'Get CR back.

dsp:

        'Set address (in words, address/2).
        S = ""
        ADDRESS = 0
        MD2xp.C4Port.Write("A")                 'Send A command.
        I = ADDRESS / 2                         'Address is in words, not bytes.
        B(0) = (I / &H100) And &HFF             'High byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        B(0) = I And &HFF                       'Low byte.
        MD2xp.C4Port.Write(B, 0, 1)             'Send it, must use a byte array.
        T = MD2xp.C4Port.ReadByte               'Get CR back.

        Do While ADDRESS < 600

            'New line every 16 bytes
            If LC = 0 Then
                LC = 16
                S += vbCrLf
                'debugflash.Write(vbCrLf)
                S += Hex((ADDRESS And &HFF00) / 256).PadLeft(2, "0"c)
                S += Hex((ADDRESS And &HFF)).PadLeft(2, "0"c)
                S += " "
                'S += Hex(ADDRESS).PadLeft(4, "0"c) & " "
            End If

            'Read 2 bytes, reads low byte first, high byte second, need to swap.
            MD2xp.C4Port.Write("R")                 'Send command.

            T1 = MD2xp.C4Port.ReadByte               'Get first byte
            T = MD2xp.C4Port.ReadByte               'Get 2nd byte

            S += Hex(T).PadLeft(2, "0"c) & " "
            'debugflash.Write(Hex(S).PadLeft(2, "0"c) & " ")

            S += Hex(T1).PadLeft(2, "0"c) & " "
            'debugflash.Write(Hex(S).PadLeft(2, "0"c) & " ")

            LC -= 2

            ADDRESS += 2

        Loop

        MsgBox(S, MsgBoxStyle.OkOnly)

    End Sub
    Private Sub UPROG(ByVal S As String)

        'Debug code
        'Update Progress 
        'LabelC4UpdateMessage.Text += S
        'Application.DoEvents()                  'Force update of label text.
        If S = "Done" Then
            'debugit.Write(vbCrLf & S & vbCrLf)
        Else
            'debugit.Write(S)
        End If

    End Sub
    Function InBootloader() As Integer

        'Return C4 bootloader version or 0 if didn't get a valid #
        'which probably means not in bootloader.

        Dim S As String
        Dim V As Integer

        Try
            MD2xp.C4Port.DiscardInBuffer()          'Clear serial buffer.
            MD2xp.C4Port.Write("V")                 'Send V (ask for version from bootloader).
            Threading.Thread.Sleep(200)             'Short wait.
            S = MD2xp.C4Port.ReadExisting           'Get results.
            V = Val(S)                              'Convert to #.  Error will be caught.
            Return V                                'Return version.
        Catch ex As Exception
            Return 0                                'False.
        End Try

    End Function

End Class