Public Class FormCircle
    Private Sub FormCircle_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'If no motor selected then select 12.
        If (Not RadioButtonCircleM12.Checked) And (Not RadioButtonCircleM34.Checked) And (Not RadioButtonCircleM56.Checked) Then
            RadioButtonCircleM12.Checked = True
        End If

        'If move type not selected then select absolute.
        If (Not RadioButtonCircleAbsolute.Checked) And (Not RadioButtonCircleRelative.Checked) Then
            RadioButtonCircleAbsolute.Checked = True
        End If

    End Sub
    Private Sub ButtonCircleCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCircleCancel.Click

        Me.Hide()

    End Sub
    Private Sub ButtonCircleMove_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCircleMove.Click

        Dim S As String = ""        'Script text.
        S = "'Circle Move" & vbCrLf

        'HourGlass Cursor.
        Me.Cursor = Cursors.WaitCursor

        'Set motors.
        MD2MOTOR = 0
        If RadioButtonCircleM12.Checked Then MD2MOTOR = 12
        If RadioButtonCircleM34.Checked Then MD2MOTOR = 34
        If RadioButtonCircleM56.Checked Then MD2MOTOR = 56

        'Set circle parameters.
        MD2CIRCLECENTERX = Val(TextBoxCircleCenterX.Text)
        MD2CIRCLECENTERY = Val(TextBoxCircleCenterY.Text)
        MD2CIRCLERADIUSX = Val(TextBoxCircleRadiusX.Text)
        MD2CIRCLERADIUSY = Val(TextBoxCircleRadiusY.Text)
        MD2CIRCLESTART = Val(TextBoxCircleStart.Text)
        MD2CIRCLEARC = Val(TextBoxCircleArc.Text)
        MD2CIRCLECHORD = Val(TextBoxCircleChord.Text)

        'Move Type.
        S += "MD2MOVETYPE=" & Chr(34)
        If RadioButtonCircleRelative.Checked Then
            MD2MOVETYPE = "R"
            S += "R"
        Else
            MD2MOVETYPE = "A"
            S += "A"
        End If
        S += Chr(34) & vbCrLf

        'Move.
        MD2CIRCLE()

        'Show status.
        MD2xp.ShowStatus(MD2STATUS)

        'Normal Cursor.
        Me.Cursor = Cursors.Default

        'If Teach Mode and move was successful (OK) then write code.
        If MD2xp.CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            S += "MD2MOTOR=" & CStr(MD2MOTOR) & vbCrLf
            S += "MD2CIRCLECENTERX=" & CStr(MD2CIRCLECENTERX) & vbCrLf
            S += "MD2CIRCLECENTERY=" & CStr(MD2CIRCLECENTERY) & vbCrLf
            S += "MD2CIRCLERADIUSX=" & CStr(MD2CIRCLERADIUSX) & vbCrLf
            S += "MD2CIRCLERADIUSY=" & CStr(MD2CIRCLERADIUSY) & vbCrLf
            S += "MD2CIRCLESTART=" & CStr(MD2CIRCLESTART) & vbCrLf
            S += "MD2CIRCLEARC=" & CStr(MD2CIRCLEARC) & vbCrLf
            S += "MD2CIRCLECHORD=" & CStr(MD2CIRCLECHORD) & vbCrLf
            S += "MD2CIRCLE" & vbCrLf
            MD2xp.TextBoxSequence.Text += S
        End If

        'Update forms.
        MD2xp.SetForms()

    End Sub
    Private Sub ButtonCircleHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCircleHelp.Click

        FormHelp.DoHelp("circlemoves")

    End Sub
    Private Sub TextBoxCircleCenterX_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _
    TextBoxCircleCenterX.TextChanged, _
    TextBoxCircleCenterY.TextChanged, _
    TextBoxCircleRadiusX.TextChanged, _
    TextBoxCircleRadiusY.TextChanged, _
    TextBoxCircleStart.TextChanged, _
    TextBoxCircleArc.TextChanged, _
    TextBoxCircleChord.TextChanged

        'If any parameter changed then set flag.
        MD2xp.ParametersUnsaved = True

    End Sub
End Class