Public Class FormGrid
    Private Sub FormGrid_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        'If no motor selected then select 12.
        If (Not RadioButtonGridM12.Checked) And (Not RadioButtonGridM34.Checked) And (Not RadioButtonGridM56.Checked) Then
            RadioButtonGridM12.Checked = True
        End If

    End Sub
    Private Sub ButtonGridCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonGridCancel.Click

        Me.Hide()

    End Sub
    Private Sub ButtonGridMove_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonGridMove.Click

        Dim S As String = ""        'Script text.
        S = "'Grid Move" & vbCrLf

        'HourGlass Cursor.
        Me.Cursor = Cursors.WaitCursor

        'Set motors.
        MD2MOTOR = 0
        If RadioButtonGridM12.Checked Then MD2MOTOR = 12
        If RadioButtonGridM34.Checked Then MD2MOTOR = 34
        If RadioButtonGridM56.Checked Then MD2MOTOR = 56

        'Set grid parameters.
        MD2GRIDBEGINX = Val(TextBoxGridBeginX.Text)
        MD2GRIDBEGINY = Val(TextBoxGridBeginY.Text)
        MD2GRIDSPACEX = Val(TextBoxGridSpacingX.Text)
        MD2GRIDSPACEY = Val(TextBoxGridSpacingY.Text)
        MD2GRIDTARGETX = Val(TextBoxGridTargetX.Text)
        MD2GRIDTARGETY = Val(TextBoxGridTargetY.Text)

        'Move.
        MD2GRID()

        'Show status.
        MD2xp.ShowStatus(MD2STATUS)

        'Normal Cursor.
        Me.Cursor = Cursors.Default

        'Teach mode.
        'If Teach Mode and move was successful (OK) then write code.
        If MD2xp.CheckBoxTeachMode.Checked And MD2STATUS = "O" Then
            S += "MD2MOTOR=" & CStr(MD2MOTOR) & vbCrLf
            S += "MD2GRIDBEGINX=" & CStr(MD2GRIDBEGINX) & vbCrLf
            S += "MD2GRIDBEGINY=" & CStr(MD2GRIDBEGINY) & vbCrLf
            S += "MD2GRIDSPACEX=" & CStr(MD2GRIDSPACEX) & vbCrLf
            S += "MD2GRIDSPACEY=" & CStr(MD2GRIDSPACEY) & vbCrLf
            S += "MD2GRIDTARGETX=" & CStr(MD2GRIDTARGETX) & vbCrLf
            S += "MD2GRIDTARGETY=" & CStr(MD2GRIDTARGETY) & vbCrLf
            S += "MD2GRID" & vbCrLf
            MD2xp.TextBoxSequence.Text += S
        End If

        'Update forms.
        MD2xp.SetForms()

    End Sub
    Private Sub ButtonGridHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonGridHelp.Click

        FormHelp.DoHelp("gridmove")

    End Sub
    Private Sub TextBoxGridBeginX_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles _
    TextBoxGridBeginX.TextChanged, _
    TextBoxGridBeginY.TextChanged, _
    TextBoxGridSpacingX.TextChanged, _
    TextBoxGridSpacingY.TextChanged, _
    TextBoxGridTargetX.TextChanged, _
    TextBoxGridTargetY.TextChanged

        'If any parameter changed then set flag.
        MD2xp.ParametersUnsaved = True

    End Sub
End Class